const express = require("express");
const router = express.Router();
require ("dotenv").config();
const passport = require('passport');

const Appl = require("../models/applications");

const Apl = require("../models/apnt_letter");

const moment = require('moment');
const flash = require("express-flash");
const bcrypt = require("bcryptjs");


const guest = require('../middleware/guest');

const gallerycontroller = require('../controller/gallerycontroller');
const store = require('../middleware/multer')


const multer = require('multer');
const fs = require('fs');


// Passport Login Module 
const User = require('../models/User');
const { forwardAuthenticated, ensureAuthenticated } = require('../config/auth');



// Image Upload
var storage = multer.diskStorage({
  destination: function(req, file, cb){
      cb(null, './uploads');
  },
  filename: function(req, file, cb){
      cb(null, file.fieldname+"_"+Date.now()+"_"+file.originalname);
  },
});

var upload = multer({
  storage: storage,
}).single("image");

///Get Index Page product
router.get("/", (req, res) =>{
  res.render('index')   
});

router.get("/about", (req, res) =>{
    res.render('about')
});

router.get("/member", (req, res) =>{
  res.render('member')   
});

router.get("/project", (req, res) =>{
  res.render('project')   
});

router.get("/bhoomiYugGarden", (req, res) =>{
  res.render('bhoomiYugGarden')   
});

router.get("/bhagwatiBhoomi", (req, res) =>{
  res.render('bhagwatiBhoomi')   
});

router.get("/gorakshResidency", (req, res) =>{
  res.render('gorakshResidency')   
});

router.get("/dishaDeep", (req, res) =>{
  res.render('dishaDeep')   
});

router.get("/privacy", (req, res) =>{
  res.render('privacy')   
});


router.get("/gallery", async (req, res) =>{
  try{
   const all_images = await UploadModel.find()
   res.render("gallery", {
     images: all_images,
   });
 }catch(err){
   console.log(err);
 }
});


router.get("/contact", (req, res) =>{
  res.render('contact')   
});

router.get("/welcome", (req, res) =>{
    res.render('welcome')
});




//For Application Modal

// Membership Form on all pages
router.post('/add', upload, (req, res) =>{
  const application = new Appl({
      name: req.body.name,
      fname: req.body.fname,  
      mname: req.body.mname,
      phone: req.body.phone,
      adhar: req.body.adhar,
      address: req.body.address,
      e_q: req.body.e_q,
      m_s: req.body.m_s,
      fam_mem: req.body.fam_mem,
      business: req.body.business,
      skill: req.body.skill,
  });
  application.save((err) =>{
      if(err){
          res.json({message: err.message, type: 'danger'});
      }else{
          req.session.message = {
              type: 'success',
              message: 'Application submitted successfully!'
          };
          res.redirect("/");
      }
  })
});


// Get All Records for fresh Application
router.get("/add_apointment", ensureAuthenticated, (req, res) =>{
  Appl.find().exec((err, appls) => {
    if(err){
        res.json({ message: err.message });
    }else{
        res.render('add_apointment', {
          title: 'add_apointment', 
          appls: appls
      })
      }
    console.log(appls);
  }); 
});


/*For Special Product Feed Home Page

router.post('/feedproduct', upload, (req, res) =>{
  const apntltr = new Sp({
      spname: req.body.spname,
      price: req.body.price,
      discprice: req.body.discprice,
      image: req.file.filename,
  });
  apntltr.save((err) =>{
      if(err){
          res.json({message: err.message, type: 'danger'});
      }else{
          req.session.message = {
              type: 'success',
              message: 'Product saved successfully!'
          };
          res.redirect("/homepage");
      }
  })
});*/

// Appoint The Member
router.post('/add_apointment', upload, (req, res) =>{
  const apntltr = new Apl({
      memberId: req.body.memberId,
      name: req.body.name,
      fname: req.body.fname,  
      phone: req.body.phone,
      email: req.body.email,
      adhar: req.body.adhar,
      district: req.body.district,
      vidhansabha: req.body.vidhansabha,
      mandal: req.body.mandal,
      state: req.body.state,
      designation: req.body.designation,
      address: req.body.address,
      refby: req.body.refby,
      date: req.body.selectedDate,
      image: req.file.filename,
  });
  apntltr.save((err) =>{
      if(err){
          res.json({message: err.message, type: 'danger'});
      }else{
          req.session.message = {
              type: 'success',
              message: 'Member Added Successfully!' 
          };
          res.redirect("/add_apointment");
      }
  })
});


// Get All membership application
router.get("/dashboard", ensureAuthenticated, (req, res) =>{
  Appl.find().exec((err, appls) => {
    if(err){
        res.json({ message: err.message });
    }else{
        res.render('dashboard', {
          title: 'dashboard', 
          appls: appls
      })
      }
    console.log(appls);
  }); 
});


// Get All Records Product Model
router.get("/homepage", (req, res) =>{
  Al.find().exec((err, apntltr) => {
    if(err){
        res.json({ message: err.message });
    }else{
        res.render('homepage', {
          title: 'Home Page', 
          apntltr: apntltr
      })
    }
  }); 
});
//For Special Product Feed Home Page

//For edit Member
router.get("/edit/:id", (req, res) =>{
  let id = req.params.id;
  Appl.findById(id, (err, memApp) => {
      if(err){
          res.redirect('/dashboard');
      }else{
          if(memApp == null){
              res.redirect('/dashboard');
          }else{
              res.render('editmember', {
                  title: "Edit Member",
                  memApp: memApp
              });
          }
      }
  })
});
//For edit Home Page Records

//Update Member
router.post("/update/:id", upload, (req, res) =>{
  let id = req.params.id;

  Appl.findByIdAndUpdate(id, {
    name: req.body.name,
    fname: req.body.fname,
    mname: req.body.mname,
    phone: req.body.phone,
    adhar: req.body.adhar,
    e_q: req.body.e_q,
    m_s: req.body.m_s,
    fam_mem: req.body.fam_mem,
    business: req.body.business,
    skill: req.body.skill,
    address: req.body.address,
  }, (err, result) => {
     if(err){
      res.json({ message: err.message });
     }else{
      req.flash(
        'success_msg',
        'Member updated successfully!'
      );
         res.redirect("/dashboard");
     }
  })
});
router.get("/editmember", (req, res) =>{
  res.render('editmember')
});


// Delete Member 
router.get('/delete/:id', (req, res) => {
  let id = req.params.id;
  Appl.findByIdAndRemove(id, (err, result) => {
      if(err){
          res.json({ message: err.message });
      }else{
          req.flash(
            'success_msg',
            'Member deleted successfully!'
          );
          res.redirect("/dashboard");
      }
  })
});
// Delete Member 

// Upload Multiple Gallery Images code below

router.get("/dgallery",gallerycontroller.gallery);
router.post('/uploadmultiple', store.array('images',12),gallerycontroller.guploads);

// Upload Multiple Gallery Images code above

// About Page Product Feed

router.get("/aboutpage", (req, res) =>{
  res.render('aboutpage')
});

router.get("/welcome", (req, res) =>{
  res.render('welcome')
}); 


//Login Passport Module Start here


// Login Page
router.get('/login', guest, forwardAuthenticated, (req, res) => res.render('login'));

// Register Page
router.get('/register', guest, forwardAuthenticated, (req, res) => res.render('register'));


// Register
router.post('/register', upload,(req, res) => {
  const { name, email, password, password2 } = req.body;

  let errors = [];

  if (!name || !email || !password || !password2) {
    errors.push({ msg: 'Please enter all fields' });
  }

  if (password != password2) {
    errors.push({ msg: 'Passwords do not match' });
  }

  // if (password.length
  //    < 6) {
  //   errors.push({ msg: 'Password must be at least 6 characters' });
  // }

  if (errors.length > 0) {
    res.render('register', {
      errors,
      name,
      email,
      password,
      password2,
    });
  } else {
    User.findOne({ email: email }).then(user => {
      if (user) {
        errors.push({ msg: 'Email already exists' });
        res.render('register', {
          errors,
          name,
          email,
          password,
          password2,
        });
      } else {
        const newUser = new User({
          name,
          email,
          password,
        });

        bcrypt.genSalt(10, (err, salt) => {
          bcrypt.hash(newUser.password, salt, (err, hash) => {
            if (err) throw err;
            newUser.password = hash;
              newUser
                .save()
                .then(user => {
                  req.flash(
                    'success_msg',
                    'You are now registered and can log in'
                  );
                  res.redirect('/welcome');
                })
                .catch(err => console.log(err));
          });
        });
      }
    });
  }
});


//Login
router.post('/login', (req, res, next) => {
  passport.authenticate('local', {
    successRedirect: '/dashboard',
    failureRedirect: '/welcome',
    failureFlash: true
  })(req, res, next);
  
});



router.get('/logout', function(req, res, next) {
  req.logout(function(err) {
    if (err) { return next(err); }
    res.redirect('/');
  });
});




module.exports = router;