// imports
const dotenv = require("dotenv");
const express = require("express");
const mongoose = require("mongoose")
const { nextTick, getMaxListeners } = require("process");
const session = require("express-session");
const passport = require('passport');
const flash = require("express-flash");
const bodyParser = require('body-parser');
// Passport Config
require('./config/passport')(passport);


const app = express();
dotenv.config()

const PORT = process.env.PORT || 5500;



mongoose.set('strictQuery', true);
mongoose.connect(process.env.DB_URI);
const db = mongoose.connection;
db.on("error", (error) => console.log(error));
db.once("open", () => {
    return console.log("Database Connected!");
});


app.use(express.urlencoded({ extended: false}));
app.use(express.json());


app.use(
    session({
        secret: process.env.SECRET_KEY,
        saveUninitialized: true,
        resave: false,
    })
);


app.use(flash());

// error message
app.use((req, res, next) =>{
    res.locals.message = req.session.message;
    delete req.session.message;
    next();
});

// Passport middleware
app.use(passport.initialize());
app.use(passport.session());

// Express body parser
app.use(express.urlencoded({ extended: true }));
    

// Global variables  passpport Msg
app.use(function(req, res, next) {
    res.locals.success_msg = req.flash('success_msg');
    res.locals.error_msg = req.flash('error_msg');
    res.locals.error = req.flash('error');
    next();
});
// Global variables  passpport Msg


//Style static folder
app.use(express.static(__dirname + '/public'));

//Image static folder
app.use(express.static("uploads"));

app.use(express.static("guploads"));

//Template Engine
app.set("view engine", "ejs");

//route prefix
app.use("", require("./router/routes"));


// For passport Login Module
app.use('/', require('./router/index.js'));
// For passport Login Module


app.listen(PORT, ()=> {
    console.log(`Server started at http://localhost:${PORT}`);
}); 