const UploadModel = require('../models/schema');
const fs = require('fs');

// this will show images on Dashboard Page
exports.gallery = async(req, res)=>{
    const all_images = await UploadModel.find()
    res.render('dgallery',{images: all_images});
}

exports.guploads = (req, res, next)=>{
    const files = req.files;

    if(!files){
        const error = new Error('Please choose files');
        error.httpStatusCode = 400;
        return next(error)
    }

    //convert images into bas64 encoding
    let imgArray = files.map((file)=>{
        let img = fs.readFileSync(file.path)

        return encode_image = img.toString('base64')
    })

    let result = imgArray.map((src, dgallery)=>{
        // create object to store data in the collection
        let finalImg = {
            filename: files[dgallery].originalname,
            contentType: files[dgallery].mimetype,
            imageBase64: src
        }
        let newUpload = new UploadModel(finalImg)

        return newUpload.save().then(()=>{
            return{msg:`Images uploaded successfully..!`}
        })
        .catch(error=>{
            if(error){
                if(error.name==='MongoError'&& error.code===11000){
                    return Promise.reject({error:`Duplicate${files[dgallery].originalname}.File already exist.`})
                }
                return Promise.reject({error: error.message || `Cannot Upload${files[dgallery].originalname} Something Missing`})
            }
        })
    });

    Promise.all(result)
    .then(msg=>{
        //res.json(msg);
        res.redirect('/dgallery')
    })
    .catch(err=>{
        res.json(err)
    })
}