

const userName = document.getElementById("name");
const fatherName = document.getElementById("fname");
const adharNum = document.getElementById("anum");
const address = document.getElementById("uaddress");
const district = document.getElementById("udistrict");
const designation = document.getElementById("udesignation");

const submitBtn = document.getElementById("submitBtn");
const { PDFDocument, rgb, degrees } = PDFLib;


submitBtn.addEventListener("click", () => {
    const val1 =userName.value;
    const val2 =fatherName.value;
    const val3 =adharNum.value;
    const val4 =address.value;
    const val5 =district.value;
    const val6 =designation.value;
    if (val1, val2, val3, val4, val5, val6.trim() !== "" && userName.checkValidity() 
    && fatherName.checkValidity() 
    && adharNum.checkValidity()
    && address.checkValidity()
    && district.checkValidity()
    && designation.checkValidity() ) {
        // console.log(val);
        generatePDF(val1, val2, val3, val4, val5, val6);
      } else {
        userName.reportValidity();
        fatherName.reportValidity();
        adharNum.reportValidity();
        address.reportValidity();
        district.reportValidity();
        designation.reportValidity();
      }
});
const generatePDF = async (name, fname, anum, uaddress, udistrict, udesignation) => {
    const existingPdfBytes = await fetch("/document/newedited.pdf").then((res) =>
      res.arrayBuffer()
    );

    // Load a PDFDocument from the existing PDF bytes
    const pdfDoc = await PDFDocument.load(existingPdfBytes);
    pdfDoc.registerFontkit(fontkit);

    
  //get font
  const fontBytes = await fetch("/font/Sanchez-Regular.ttf").then((res) =>
  res.arrayBuffer()
);
  // Embed our custom font in the document
  const SanChezFont  = await pdfDoc.embedFont(fontBytes);
   // Get the first page of the document
   const pages = pdfDoc.getPages();
   const firstPage = pages[0];
 
   // Draw a string of text diagonally across the first page
  firstPage.drawText(name, {
     x: 300,
     y: 515,
     size: 10,
     font: SanChezFont ,
     color: rgb(0, 0, 0),
  });
  firstPage.drawText(fname, {
    x: 65,
    y: 472,
    size: 10,
    font: SanChezFont ,
    color: rgb(0, 0, 0),
  });
  firstPage.drawText(anum, {
    x: 340,
    y: 472,
    size: 10,
    font: SanChezFont ,
    color: rgb(0, 0, 0),
  });
  firstPage.drawText(uaddress, {
    x: 80,
    y: 430,
    size: 10,
    font: SanChezFont ,
    color: rgb(0, 0, 0),
  });
  firstPage.drawText(udistrict, {
    x: 80,
    y: 385,
    size: 10,
    font: SanChezFont ,
    color: rgb(0, 0, 0),
  });
  firstPage.drawText(udesignation, {
    x: 335,
    y: 385,
    size: 10,
    font: SanChezFont ,
    color: rgb(0, 0, 0),
  });
 
  // Serialize the PDFDocument to bytes (a Uint8Array)
  const pdfDataUri = await pdfDoc.saveAsBase64({ dataUri: true });
  saveAs(pdfDataUri,"NewAppointment.pdf")
};

